# Coventry Mechanic Website - Template Handover Guide

## Overview

This is a fully functional, template-style website for a Coventry mechanic/garage. All content is driven from JSON files in the `data/` directory, making it easy to update without touching code.

## Quick Start

1. **Upload files** to your web server (PHP 7.4+ required)
2. **Update business information** in `data/business.json`
3. **Customize services** in `data/services.json`
4. **Update pricing** in `data/pricing.json`
5. **Add testimonials** in `data/testimonials.json`

## Directory Structure

```
coventry-mechanic/
├── data/                    # All content files (JSON)
│   ├── business.json        # Business info, contact, hours
│   ├── services.json        # All service listings
│   ├── pricing.json         # Pricing bands and rules
│   ├── testimonials.json    # Customer reviews
│   ├── areas.json           # Areas served
│   ├── faqs.json            # Frequently asked questions
│   └── pages.json           # Static page content
├── partials/                # Reusable page components
│   ├── header.php           # Site header & navigation
│   ├── footer.php           # Site footer
│   ├── breadcrumbs.php      # Breadcrumb navigation
│   ├── cookie-banner.php    # Cookie consent banner
│   ├── cta-strip.php        # Call-to-action strip
│   ├── service-card.php     # Service card component
│   └── review-card.php      # Review card component
├── api/                     # API endpoints
│   └── quote.php            # Quick quote calculator
├── config.php               # Site configuration
├── index.php                # Homepage
├── services.php             # Services hub page
├── service-detail.php       # Individual service pages
├── pricing.php              # Pricing page
├── about.php                # About page
├── contact.php              # Contact page
├── reviews.php              # Reviews page
├── faq.php                  # FAQ page
├── privacy-policy.php       # Privacy policy
├── cookie-policy.php        # Cookie policy
├── terms.php                # Terms of service
├── sitemap.php              # HTML sitemap
├── sitemap.xml.php          # XML sitemap generator
├── robots.txt               # Search engine directives
└── .htaccess                # URL rewriting rules
```

## Editing Content

### 1. Business Information (`data/business.json`)

Update your business details:

```json
{
  "name": "Your Business Name",
  "legal_name": "Your Business Name Ltd",
  "tagline": "Your Tagline",
  "contact": {
    "phone": "024 7654 3210",
    "phone_formatted": "+442476543210",
    "email": "info@yourbusiness.co.uk",
    "address": {
      "street": "123 Your Street",
      "city": "Coventry",
      "postcode": "CV1 2AB"
    },
    "coordinates": {
      "lat": 52.4068,
      "lng": -1.5197
    }
  },
  "opening_hours": {
    "monday": {
      "open": "08:00",
      "close": "17:30",
      "closed": false
    }
    // ... other days
  }
}
```

**Important:** Update the coordinates for Google Maps embedding.

### 2. Services (`data/services.json`)

Each service has this structure:

```json
{
  "id": "service-id",
  "slug": "service-url-slug",
  "title": "Service Title",
  "short": "Brief description",
  "long": "Detailed description",
  "icon": "🔧",
  "category": "Servicing",
  "benefits": ["Benefit 1", "Benefit 2"],
  "faqs": [
    {
      "question": "Question?",
      "answer": "Answer."
    }
  ],
  "meta_title": "SEO Title",
  "meta_description": "SEO Description",
  "primary_keyword": "Main Keyword",
  "secondary_keywords": ["Keyword 1", "Keyword 2"]
}
```

**To add a new service:**
1. Copy an existing service object
2. Update all fields
3. Ensure `slug` is unique (lowercase, hyphens only)
4. Add to the `services` array

**To edit a service:**
1. Find the service by `id` or `slug`
2. Update the fields you want to change
3. Save the file

### 3. Pricing (`data/pricing.json`)

Pricing structure:

```json
{
  "pricing_bands": {
    "mot": {
      "car": {
        "from": 54.85,
        "to": 54.85,
        "fixed": true,
        "description": "MOT test for cars"
      }
    },
    "servicing": {
      "interim": {
        "from": 120,
        "to": 180,
        "description": "Interim service",
        "factors": ["Vehicle make/model", "Engine size"]
      }
    }
  }
}
```

**To update prices:**
- Change `from` and `to` values
- Set `fixed: true` for fixed prices
- Add `factors` array to explain price variations

### 4. Testimonials (`data/testimonials.json`)

Add reviews:

```json
{
  "id": 11,
  "name_initials": "J. S.",
  "vehicle": "Ford Focus",
  "rating": 5,
  "text": "Great service!",
  "date": "2024-04-15",
  "service": "MOT & Service"
}
```

**To add a review:**
1. Copy an existing review
2. Update all fields
3. Use date format: `YYYY-MM-DD`
4. Rating: 1-5 stars

### 5. FAQs (`data/faqs.json`)

FAQ structure:

```json
{
  "id": 13,
  "category": "General",
  "question": "Your question?",
  "answer": "Your answer."
}
```

**Categories:** General, MOT, Servicing, Pricing, Repairs

### 6. Areas Served (`data/areas.json`)

Update areas:

```json
{
  "primary_area": {
    "name": "Coventry",
    "description": "Your description"
  },
  "areas_served": [
    {
      "name": "Area Name",
      "slug": "area-slug"
    }
  ]
}
```

## SEO Settings

### Meta Tags

Each service page has SEO fields:
- `meta_title`: Page title (≤60 characters)
- `meta_description`: Description (≤160 characters)
- `primary_keyword`: Main keyword
- `secondary_keywords`: Array of related keywords

**Best Practices:**
- Include location (e.g., "Coventry")
- Be descriptive, not keyword-stuffed
- Make titles compelling for click-through

### Sitemap

The sitemap is automatically generated from:
- All static pages
- All service pages
- Policy pages

Access at: `https://yourdomain.com/sitemap.xml`

### robots.txt

Located at root: `robots.txt`

Currently allows all indexing. Update if needed.

## Configuration

### Site URL (`config.php`)

Update the site URL:

```php
define('SITE_URL', 'https://yourdomain.com');
```

### Google Maps

In `contact.php`, replace `YOUR_API_KEY` with your Google Maps API key:

```html
src="https://www.google.com/maps/embed/v1/place?key=YOUR_API_KEY&q=..."
```

## Contact Form

The contact form (`contact.php`) includes:
- Basic validation
- Honeypot spam protection
- Logs submissions to `contact_log.txt`

**To send emails:**
1. Update `contact.php` with your email sending code
2. Use PHP `mail()` or a library like PHPMailer

## Quick Quote Calculator

The calculator (`api/quote.php`) calculates estimates based on:
- Service type
- Vehicle type (car/van)
- Engine size
- Urgency

**To modify calculations:**
- Edit `data/pricing.json` → `estimate_rules`
- Adjust multipliers in `api/quote.php`

## Styling

The site uses **Tailwind CSS** via CDN. To customize:

1. **Colors:** Search for `blue-600`, `gray-800`, etc. and replace
2. **Fonts:** Update in `partials/header.php`
3. **Layout:** Modify Tailwind classes in PHP files

**To use local Tailwind:**
1. Install Tailwind CLI
2. Replace CDN link with compiled CSS
3. Configure `tailwind.config.js`

## Adding New Pages

1. Create `new-page.php` in root
2. Include header/footer:
   ```php
   <?php require_once 'config.php'; ?>
   <?php include 'partials/header.php'; ?>
   <!-- Your content -->
   <?php include 'partials/footer.php'; ?>
   ```
3. Add to navigation in `partials/header.php`
4. Add to sitemap in `sitemap.xml.php`

## URL Structure

Clean URLs are enabled via `.htaccess`:

- `/services/mot-coventry/` → `service-detail.php?slug=mot-coventry`
- `/pricing` → `pricing.php`
- `/sitemap.xml` → `sitemap.xml.php`

**To add new URL patterns:**
Edit `.htaccess` with new `RewriteRule` entries.

## Security Notes

- All output is escaped using `e()` function
- Form inputs are validated and sanitized
- Honeypot field prevents basic spam
- Security headers in `.htaccess`

**Recommended:**
- Enable HTTPS
- Regular backups
- Keep PHP updated
- Monitor `contact_log.txt` for spam

## Troubleshooting

### Pages not loading
- Check PHP version (7.4+)
- Verify `.htaccess` is enabled
- Check file permissions

### JSON errors
- Validate JSON syntax (use JSONLint.com)
- Check for trailing commas
- Ensure proper quotes (double, not single)

### Images not showing
- Add images to `/assets/` directory
- Update image paths in JSON/content
- Check file permissions

### Contact form not working
- Check PHP `mail()` configuration
- Verify form action path
- Check server error logs

## Support

For template customization:
1. Review existing code structure
2. Test changes on staging first
3. Keep backups of JSON files
4. Document custom changes

## License & Credits

This is a template website. Customize as needed for your business.

---

**Last Updated:** April 2024
