<?php
// Generate breadcrumbs based on current page
$current_slug = get_current_slug();
$breadcrumbs = [['name' => 'Home', 'url' => '/']];

if ($current_slug === 'services') {
    $breadcrumbs[] = ['name' => 'Services', 'url' => '/services'];
} elseif (strpos($current_slug, 'services/') === 0) {
    $breadcrumbs[] = ['name' => 'Services', 'url' => '/services'];
    $service_slug = str_replace('services/', '', $current_slug);
    $service = get_service_by_slug($service_slug);
    if ($service) {
        $breadcrumbs[] = ['name' => $service['title'], 'url' => '/services/' . $service['slug']];
    }
} elseif ($current_slug !== 'home' && $current_slug !== '') {
    $page_name = ucfirst(str_replace('-', ' ', $current_slug));
    $breadcrumbs[] = ['name' => $page_name, 'url' => '/' . $current_slug];
}

if (count($breadcrumbs) > 1):
?>
<nav aria-label="Breadcrumb" class="bg-gray-100 py-3">
    <div class="container mx-auto px-4">
        <ol class="flex items-center space-x-2 text-sm">
            <?php foreach ($breadcrumbs as $index => $crumb): ?>
                <li class="flex items-center">
                    <?php if ($index > 0): ?>
                        <svg class="w-4 h-4 text-gray-400 mx-2" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M7.293 14.707a1 1 0 010-1.414L10.586 10 7.293 6.707a1 1 0 011.414-1.414l4 4a1 1 0 010 1.414l-4 4a1 1 0 01-1.414 0z" clip-rule="evenodd"></path>
                        </svg>
                    <?php endif; ?>
                    <?php if ($index === count($breadcrumbs) - 1): ?>
                        <span class="text-gray-600 font-medium" aria-current="page"><?php echo e($crumb['name']); ?></span>
                    <?php else: ?>
                        <a href="<?php echo e($crumb['url']); ?>" class="text-blue-600 hover:text-blue-800"><?php echo e($crumb['name']); ?></a>
                    <?php endif; ?>
                </li>
            <?php endforeach; ?>
        </ol>
    </div>
</nav>

<script type="application/ld+json">
{
    "@context": "https://schema.org",
    "@type": "BreadcrumbList",
    "itemListElement": [
        <?php
        $items = [];
        foreach ($breadcrumbs as $index => $crumb) {
            $items[] = '{
                "@type": "ListItem",
                "position": ' . ($index + 1) . ',
                "name": "' . e($crumb['name']) . '",
                "item": "' . get_canonical_url($crumb['url']) . '"
            }';
        }
        echo implode(',', $items);
        ?>
    ]
}
</script>
<?php endif; ?>
