    <!-- Modern Footer -->
    <footer class="bg-gradient-to-br from-gray-900 via-gray-800 to-gray-900 text-white mt-20 relative overflow-hidden">
        <!-- Decorative Elements -->
        <div class="absolute top-0 left-0 w-full h-1 bg-gradient-to-r from-blue-600 via-purple-600 to-blue-600"></div>
        <div class="absolute inset-0 opacity-10">
            <div class="absolute top-20 left-10 w-72 h-72 bg-blue-500 rounded-full mix-blend-multiply filter blur-3xl"></div>
            <div class="absolute bottom-20 right-10 w-72 h-72 bg-purple-500 rounded-full mix-blend-multiply filter blur-3xl"></div>
        </div>
        
        <div class="container mx-auto px-4 py-16 relative z-10">
            <div class="grid grid-cols-1 md:grid-cols-4 gap-10">
                <!-- Company Info -->
                <div>
                    <h3 class="text-2xl font-bold mb-4 bg-gradient-to-r from-blue-400 to-purple-400 bg-clip-text text-transparent">
                        <?php echo e($business['name'] ?? SITE_NAME); ?>
                    </h3>
                    <p class="text-gray-300 mb-6 leading-relaxed"><?php echo e($business['tagline'] ?? ''); ?></p>
                    <?php if (isset($business['established'])): ?>
                    <div class="flex items-center text-gray-400 text-sm">
                        <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                        Established <?php echo $business['established']; ?>
                    </div>
                    <?php endif; ?>
                </div>
                
                <!-- Contact -->
                <div>
                    <h3 class="text-xl font-bold mb-6 flex items-center">
                        <svg class="w-5 h-5 mr-2 text-blue-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"></path>
                        </svg>
                        Contact
                    </h3>
                    <?php if (isset($business['contact']['phone'])): ?>
                    <p class="text-gray-300 mb-4 flex items-center group">
                        <svg class="w-5 h-5 mr-3 text-blue-400 group-hover:scale-110 transition-transform" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z"></path>
                        </svg>
                        <a href="tel:<?php echo e($business['contact']['phone_formatted'] ?? $business['contact']['phone']); ?>" class="hover:text-blue-400 transition-colors">
                            <?php echo e($business['contact']['phone']); ?>
                        </a>
                    </p>
                    <?php endif; ?>
                    <p class="text-gray-300 mb-4 flex items-center">
                        <svg class="w-5 h-5 mr-3 text-blue-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"></path>
                        </svg>
                        <span>Use our contact form to get in touch</span>
                    </p>
                    <?php if (isset($business['contact']['address']['full'])): ?>
                    <p class="text-gray-300 text-sm flex items-start">
                        <svg class="w-5 h-5 mr-3 text-blue-400 mt-1 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"></path>
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"></path>
                        </svg>
                        <span><?php echo e($business['contact']['address']['full']); ?></span>
                    </p>
                    <?php endif; ?>
                </div>
                
                <!-- Quick Links -->
                <div>
                    <h3 class="text-xl font-bold mb-6 flex items-center">
                        <svg class="w-5 h-5 mr-2 text-blue-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13.828 10.172a4 4 0 00-5.656 0l-4 4a4 4 0 105.656 5.656l1.102-1.101m-.758-4.899a4 4 0 005.656 0l4-4a4 4 0 00-5.656-5.656l-1.1 1.1"></path>
                        </svg>
                        Quick Links
                    </h3>
                    <ul class="space-y-3">
                        <li><a href="/services" class="flex items-center text-gray-300 hover:text-blue-400 hover:translate-x-2 transition-all duration-300 group">
                            <svg class="w-4 h-4 mr-2 group-hover:scale-110 transition-transform" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
                            </svg>
                            Our Services
                        </a></li>
                        <li><a href="/pricing" class="flex items-center text-gray-300 hover:text-blue-400 hover:translate-x-2 transition-all duration-300 group">
                            <svg class="w-4 h-4 mr-2 group-hover:scale-110 transition-transform" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
                            </svg>
                            Pricing
                        </a></li>
                        <li><a href="/about" class="flex items-center text-gray-300 hover:text-blue-400 hover:translate-x-2 transition-all duration-300 group">
                            <svg class="w-4 h-4 mr-2 group-hover:scale-110 transition-transform" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
                            </svg>
                            About Us
                        </a></li>
                        <li><a href="/reviews" class="flex items-center text-gray-300 hover:text-blue-400 hover:translate-x-2 transition-all duration-300 group">
                            <svg class="w-4 h-4 mr-2 group-hover:scale-110 transition-transform" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
                            </svg>
                            Reviews
                        </a></li>
                        <li><a href="/faq" class="flex items-center text-gray-300 hover:text-blue-400 hover:translate-x-2 transition-all duration-300 group">
                            <svg class="w-4 h-4 mr-2 group-hover:scale-110 transition-transform" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
                            </svg>
                            FAQ
                        </a></li>
                        <li><a href="/contact" class="flex items-center text-gray-300 hover:text-blue-400 hover:translate-x-2 transition-all duration-300 group">
                            <svg class="w-4 h-4 mr-2 group-hover:scale-110 transition-transform" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
                            </svg>
                            Contact
                        </a></li>
                    </ul>
                </div>
                
                <!-- Opening Hours -->
                <div>
                    <h3 class="text-xl font-bold mb-6 flex items-center">
                        <svg class="w-5 h-5 mr-2 text-blue-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                        Opening Hours
                    </h3>
                    <ul class="space-y-3 text-sm">
                        <?php
                        if (isset($business['opening_hours']) && is_array($business['opening_hours'])) {
                            $hours = $business['opening_hours'];
                            $day_names = ['Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday', 'Sunday'];
                            $day_keys = ['monday', 'tuesday', 'wednesday', 'thursday', 'friday', 'saturday', 'sunday'];
                            foreach ($day_keys as $index => $day) {
                                $day_name = $day_names[$index];
                                if (isset($hours[$day]) && ($hours[$day]['closed'] ?? false)) {
                                    echo "<li class='flex items-center justify-between py-2 border-b border-gray-700/50'><span class='text-gray-300'>$day_name</span><span class='text-gray-500'>Closed</span></li>";
                                } elseif (isset($hours[$day])) {
                                    echo "<li class='flex items-center justify-between py-2 border-b border-gray-700/50'><span class='text-gray-300'>$day_name</span><span class='text-blue-400 font-semibold'>{$hours[$day]['open']} - {$hours[$day]['close']}</span></li>";
                                }
                            }
                        } else {
                            echo "<li class='flex items-center justify-between py-2 border-b border-gray-700/50'><span class='text-gray-300'>Monday - Friday</span><span class='text-blue-400 font-semibold'>8:00 AM - 5:30 PM</span></li>";
                            echo "<li class='flex items-center justify-between py-2 border-b border-gray-700/50'><span class='text-gray-300'>Saturday</span><span class='text-blue-400 font-semibold'>8:00 AM - 12:30 PM</span></li>";
                            echo "<li class='flex items-center justify-between py-2 border-b border-gray-700/50'><span class='text-gray-300'>Sunday</span><span class='text-gray-500'>Closed</span></li>";
                        }
                        ?>
                    </ul>
                </div>
            </div>
            
            <div class="border-t border-gray-700/50 mt-12 pt-8">
                <div class="flex flex-col md:flex-row justify-between items-center">
                    <p class="text-gray-400 text-sm mb-4 md:mb-0">
                        &copy; <?php echo date('Y'); ?> <?php echo e($business['legal_name'] ?? SITE_NAME); ?>. All rights reserved.
                    </p>
                    <div class="flex flex-wrap justify-center gap-4 text-sm">
                        <a href="/privacy-policy" class="text-gray-400 hover:text-blue-400 transition-colors flex items-center group">
                            <span class="group-hover:underline">Privacy Policy</span>
                        </a>
                        <span class="text-gray-600">•</span>
                        <a href="/cookie-policy" class="text-gray-400 hover:text-blue-400 transition-colors flex items-center group">
                            <span class="group-hover:underline">Cookie Policy</span>
                        </a>
                        <span class="text-gray-600">•</span>
                        <a href="/terms" class="text-gray-400 hover:text-blue-400 transition-colors flex items-center group">
                            <span class="group-hover:underline">Terms</span>
                        </a>
                        <span class="text-gray-600">•</span>
                        <a href="/sitemap" class="text-gray-400 hover:text-blue-400 transition-colors flex items-center group">
                            <span class="group-hover:underline">Sitemap</span>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </footer>
    
    <?php include __DIR__ . '/cookie-banner.php'; ?>
    <?php include __DIR__ . '/proposal-modal.php'; ?>
    <?php include __DIR__ . '/review-modal.php'; ?>
    
    <script>
        // Analytics Event Tracking
        function trackAnalyticsEvent(eventType, data = {}) {
            // Don't track if bot (shouldn't happen, but safety check)
            if (navigator.userAgent.match(/bot|crawl|slurp|spider|facebookexternalhit|twitterbot|linkedinbot/i)) {
                return;
            }
            
            fetch('/api/analytics-event', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                },
                body: JSON.stringify({
                    event_type: eventType,
                    data: {
                        ...data,
                        page: window.location.pathname,
                        url: window.location.href
                    }
                })
            }).catch(err => {
                // Silently fail - don't interrupt user experience
                console.debug('Analytics tracking failed:', err);
            });
        }
        
        // Track clicks on links (navigation)
        document.addEventListener('click', function(e) {
            const link = e.target.closest('a');
            if (link && link.href) {
                const href = link.getAttribute('href');
                // Track internal navigation (not external links, not anchors)
                if (href.startsWith('/') && !href.startsWith('//') && !href.startsWith('#')) {
                    trackAnalyticsEvent('navigation', {
                        target: href,
                        link_text: link.textContent.trim().substring(0, 50)
                    });
                }
            }
            
            // Track general clicks (excluding navigation links)
            if (!link || !link.href || link.href.startsWith('#')) {
                trackAnalyticsEvent('click', {
                    element: e.target.tagName,
                    element_id: e.target.id || '',
                    element_class: e.target.className || ''
                });
            }
        });
        
        // Smooth scroll for anchor links
        document.querySelectorAll('a[href^="#"]').forEach(anchor => {
            anchor.addEventListener('click', function (e) {
                e.preventDefault();
                const target = document.querySelector(this.getAttribute('href'));
                if (target) {
                    target.scrollIntoView({ behavior: 'smooth', block: 'start' });
                }
            });
        });
    </script>
</body>
</html>
