<?php
// Review card partial
// Usage: include with $review variable set
?>
<div class="card-hover bg-white rounded-2xl shadow-lg hover:shadow-2xl p-8 border border-gray-100 group relative overflow-hidden">
    <!-- Decorative gradient background -->
    <div class="absolute top-0 right-0 w-32 h-32 bg-gradient-to-br from-indigo-100 via-purple-100 to-pink-100 rounded-full opacity-20 blur-2xl"></div>
    
    <div class="relative z-10">
        <div class="flex items-start mb-6">
            <div class="flex-shrink-0 w-14 h-14 bg-gradient-to-br from-indigo-500 via-purple-500 to-pink-500 rounded-full flex items-center justify-center text-white font-bold text-lg mr-4 shadow-lg">
                <?php echo strtoupper(substr($review['name_initials'], 0, 2)); ?>
            </div>
            <div class="flex-1">
                <div class="flex items-center justify-between mb-3">
                    <div class="flex items-center">
                        <div class="flex text-yellow-400 mr-3">
                            <?php for ($i = 0; $i < $review['rating']; $i++): ?>
                                <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20">
                                    <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"></path>
                                </svg>
                            <?php endfor; ?>
                        </div>
                        <span class="font-bold text-gray-900"><?php echo e($review['name_initials']); ?></span>
                    </div>
                </div>
                <p class="text-sm text-gray-600 mb-4 flex items-center">
                    <svg class="w-4 h-4 mr-2 text-purple-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                    </svg>
                    <?php echo e($review['vehicle']); ?> • <?php echo e($review['service'] ?? 'Service'); ?>
                </p>
                <p class="text-gray-700 mb-4 leading-relaxed italic">"<?php echo e($review['text']); ?>"</p>
                <p class="text-xs text-gray-500 flex items-center">
                    <svg class="w-3 h-3 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"></path>
                    </svg>
                    <?php echo date('F Y', strtotime($review['date'])); ?>
                </p>
            </div>
        </div>
    </div>
</div>
