<?php
// Service card partial
// Usage: include with $service variable set
?>
<div class="card-hover bg-white rounded-2xl shadow-lg hover:shadow-2xl transition-all duration-300 p-8 border border-gray-100 group">
    <div class="flex items-start mb-6">
        <div class="flex-shrink-0 w-16 h-16 bg-gradient-to-br from-blue-500 to-purple-600 rounded-xl flex items-center justify-center text-3xl shadow-lg group-hover:scale-110 transition-transform duration-300">
            <?php echo e($service['icon'] ?? '🔧'); ?>
        </div>
        <div class="flex-1 ml-4">
            <h3 class="text-xl font-bold text-gray-900 mb-3 group-hover:text-blue-600 transition-colors">
                <a href="/services/<?php echo e($service['slug']); ?>" class="hover:text-blue-600">
                    <?php echo e($service['title']); ?>
                </a>
            </h3>
            <p class="text-gray-600 mb-5 leading-relaxed"><?php echo e($service['short']); ?></p>
            <?php if (isset($service['benefits']) && count($service['benefits']) > 0): ?>
            <ul class="text-sm text-gray-600 space-y-2 mb-6">
                <?php foreach (array_slice($service['benefits'], 0, 3) as $benefit): ?>
                <li class="flex items-start">
                    <svg class="w-5 h-5 text-green-500 mr-2 mt-0.5 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path>
                    </svg>
                    <span><?php echo e($benefit); ?></span>
                </li>
                <?php endforeach; ?>
            </ul>
            <?php endif; ?>
            <a href="/services/<?php echo e($service['slug']); ?>" 
               class="inline-flex items-center text-blue-600 font-semibold hover:text-purple-600 group-hover:gap-2 transition-all duration-300">
                Learn more
                <svg class="w-4 h-4 ml-1 group-hover:translate-x-1 transition-transform" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
                </svg>
            </a>
        </div>
    </div>
</div>
