<?php
require_once __DIR__ . '/../config.php';
$current_slug = 'faq';

// Group FAQs by category
$faqs_by_category = [];
foreach ($faqs_data['faqs'] as $faq) {
    $cat = $faq['category'] ?? 'General';
    if (!isset($faqs_by_category[$cat])) {
        $faqs_by_category[$cat] = [];
    }
    $faqs_by_category[$cat][] = $faq;
}
?>
<?php include __DIR__ . '/../partials/header.php'; ?>
<?php include __DIR__ . '/../partials/breadcrumbs.php'; ?>

<section class="py-16 bg-white">
    <div class="container mx-auto px-4">
        <div class="max-w-4xl mx-auto">
            <h1 class="text-4xl font-bold text-center mb-4">Frequently Asked Questions</h1>
            <p class="text-center text-gray-600 mb-12">
                Find answers to common questions about our services
            </p>
            
            <div class="space-y-8">
                <?php foreach ($faqs_by_category as $category => $faqs): ?>
                <div>
                    <h2 class="text-2xl font-bold mb-4"><?php echo e($category); ?></h2>
                    <div class="space-y-4">
                        <?php foreach ($faqs as $faq): ?>
                        <div class="bg-gray-50 rounded-lg p-6">
                            <h3 class="font-semibold text-lg mb-2"><?php echo e($faq['question']); ?></h3>
                            <p class="text-gray-700"><?php echo e($faq['answer']); ?></p>
                        </div>
                        <?php endforeach; ?>
                    </div>
                </div>
                <?php endforeach; ?>
            </div>
            
            <!-- FAQ Schema -->
            <script type="application/ld+json">
            {
                "@context": "https://schema.org",
                "@type": "FAQPage",
                "mainEntity": [
                    <?php
                    $faq_items = [];
                    foreach ($faqs_data['faqs'] as $faq) {
                        $faq_items[] = '{
                            "@type": "Question",
                            "name": "' . e($faq['question']) . '",
                            "acceptedAnswer": {
                                "@type": "Answer",
                                "text": "' . e($faq['answer']) . '"
                            }
                        }';
                    }
                    echo implode(',', $faq_items);
                    ?>
                ]
            }
            </script>
            
            <div class="mt-12 text-center">
                <p class="text-gray-600 mb-4">Still have questions?</p>
                <a href="/contact" class="inline-block bg-blue-600 text-white px-8 py-3 rounded-lg font-semibold hover:bg-blue-700 transition">
                    Contact Us
                </a>
            </div>
        </div>
    </div>
</section>

<!-- CTA Section -->
<?php include __DIR__ . '/../partials/cta-strip.php'; ?>

<?php include __DIR__ . '/../partials/footer.php'; ?>
