<?php
require_once __DIR__ . '/../config.php';
$current_slug = 'home';
?>
<?php include __DIR__ . '/../partials/header.php'; ?>
<?php include __DIR__ . '/../partials/breadcrumbs.php'; ?>

<!-- Modern Hero Section with Gradient and Animations -->
<section class="relative bg-gradient-to-br from-blue-600 via-purple-600 to-indigo-700 text-white py-20 overflow-hidden">
    <!-- Animated Background Elements -->
    <div class="absolute inset-0 overflow-hidden">
        <div class="absolute -top-40 -right-40 w-80 h-80 bg-purple-300 rounded-full mix-blend-multiply filter blur-xl opacity-20 animate-pulse"></div>
        <div class="absolute -bottom-40 -left-40 w-80 h-80 bg-blue-300 rounded-full mix-blend-multiply filter blur-xl opacity-20 animate-pulse" style="animation-delay: 2s;"></div>
    </div>
    
    <div class="container mx-auto px-4 relative z-10">
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
            <div class="animate-fade-in-up">
                <h1 class="text-5xl md:text-6xl font-extrabold mb-6 leading-tight">
                    <span class="bg-gradient-to-r from-white to-blue-100 bg-clip-text text-transparent">
                        Trusted Car Servicing & MOT
                    </span>
                    <br>
                    <span class="text-yellow-300">in Coventry</span>
                </h1>
                <p class="text-xl md:text-2xl mb-8 text-blue-100 leading-relaxed">
                    Professional automotive services with fair pricing and quality workmanship. 
                    Get an instant estimate for your service needs.
                </p>
                <div class="flex flex-col sm:flex-row gap-4">
                    <a href="/contact" class="btn-modern bg-white text-blue-600 px-8 py-4 rounded-xl font-bold hover:shadow-2xl hover:scale-105 transition-all duration-300 text-center">
                        📅 Book Appointment
                    </a>
                    <a href="tel:<?php echo e(isset($business['contact']['phone_formatted']) ? $business['contact']['phone_formatted'] : ''); ?>" 
                       class="btn-modern bg-blue-700/90 backdrop-blur-sm text-white px-8 py-4 rounded-xl font-bold hover:bg-blue-800 hover:shadow-2xl hover:scale-105 transition-all duration-300 text-center border-2 border-blue-500/50">
                        📞 Call <?php echo e(isset($business['contact']['phone']) ? $business['contact']['phone'] : ''); ?>
                    </a>
                </div>
            </div>
            
            <!-- Modern Quick Quote Calculator with Glassmorphism -->
            <div id="quick-quote" class="glass bg-white/95 backdrop-blur-md rounded-2xl shadow-2xl p-8 text-gray-900 animate-slide-in-right border border-white/20">
                <div class="text-center mb-6">
                    <div class="inline-flex items-center justify-center w-16 h-16 bg-gradient-to-r from-blue-600 to-purple-600 rounded-full mb-4">
                        <svg class="w-8 h-8 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 7h6m0 10v-3m-3 3h.01M9 17h.01M9 14h.01M12 14h.01M15 11h.01M12 11h.01M9 11h.01M7 21h10a2 2 0 002-2V5a2 2 0 00-2-2H7a2 2 0 00-2 2v14a2 2 0 002 2z"></path>
                        </svg>
                    </div>
                    <h2 class="text-3xl font-bold mb-2 bg-gradient-to-r from-blue-600 to-purple-600 bg-clip-text text-transparent">Quick Quote Calculator</h2>
                    <p class="text-gray-600 text-sm">Get an instant estimate</p>
                </div>
                <form id="quick-quote-form" class="space-y-4">
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Service Type</label>
                        <select id="quote-service" name="service" class="w-full border border-gray-300 rounded-lg px-4 py-2 focus:ring-2 focus:ring-blue-500 focus:border-blue-500" required>
                            <option value="">Select a service...</option>
                            <option value="mot">MOT Test</option>
                            <option value="interim">Interim Service</option>
                            <option value="full">Full Service</option>
                            <option value="brakes">Brake Repair</option>
                            <option value="diagnostics">Diagnostics</option>
                            <option value="aircon">Air Conditioning</option>
                            <option value="clutch">Clutch Repair</option>
                            <option value="tyres">Tyres</option>
                            <option value="cambelt">Cambelt Replacement</option>
                        </select>
                    </div>
                    
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Vehicle Type</label>
                        <select id="quote-vehicle" name="vehicle" class="w-full border border-gray-300 rounded-lg px-4 py-2 focus:ring-2 focus:ring-blue-500 focus:border-blue-500" required>
                            <option value="car">Car</option>
                            <option value="van">Van</option>
                        </select>
                    </div>
                    
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Engine Size (Optional)</label>
                        <select id="quote-engine" name="engine" class="w-full border border-gray-300 rounded-lg px-4 py-2 focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                            <option value="medium">Medium (1.4L - 2.0L)</option>
                            <option value="small">Small (Under 1.4L)</option>
                            <option value="large">Large (Over 2.0L)</option>
                        </select>
                    </div>
                    
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Urgency</label>
                        <select id="quote-urgency" name="urgency" class="w-full border border-gray-300 rounded-lg px-4 py-2 focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                            <option value="standard">Standard</option>
                            <option value="urgent">Urgent</option>
                            <option value="emergency">Emergency</option>
                        </select>
                    </div>
                    
                    <button type="submit" class="btn-modern w-full bg-gradient-to-r from-blue-600 to-purple-600 text-white px-6 py-4 rounded-xl font-bold hover:from-blue-700 hover:to-purple-700 shadow-lg hover:shadow-xl transition-all duration-300 transform hover:scale-105">
                        💰 Get Estimate
                    </button>
                </form>
                
                <!-- Modern Results Display -->
                <div id="quote-results" class="hidden mt-6 p-6 bg-gradient-to-br from-blue-50 to-purple-50 rounded-2xl border-2 border-blue-200 animate-fade-in-up">
                    <div class="text-center mb-4">
                        <div class="inline-flex items-center justify-center w-16 h-16 bg-gradient-to-r from-green-500 to-green-600 rounded-full mb-3 shadow-lg">
                            <svg class="w-8 h-8 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
                            </svg>
                        </div>
                        <h3 class="font-bold text-xl mb-2 text-gray-900">Estimated Price</h3>
                        <p id="quote-price" class="text-4xl font-extrabold bg-gradient-to-r from-blue-600 to-purple-600 bg-clip-text text-transparent mb-2"></p>
                        <p id="quote-time" class="text-sm text-gray-600 mb-4 flex items-center justify-center">
                            <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                            </svg>
                            <span id="quote-time-text"></span>
                        </p>
                    </div>
                    <p class="text-xs text-gray-500 mb-4 text-center italic">*This is an estimate. Final price may vary after vehicle inspection.</p>
                    <a href="/contact" class="btn-modern block w-full bg-gradient-to-r from-blue-600 to-purple-600 text-white px-6 py-3 rounded-xl font-bold hover:from-blue-700 hover:to-purple-700 shadow-lg hover:shadow-xl transition-all duration-300 transform hover:scale-105 text-center">
                        📅 Book Now
                    </a>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Top Services with Modern Design -->
<section class="py-20 bg-gradient-to-b from-white to-gray-50">
    <div class="container mx-auto px-4">
        <div class="text-center mb-16 animate-fade-in-up">
            <h2 class="text-4xl md:text-5xl font-extrabold mb-4 bg-gradient-to-r from-blue-600 to-purple-600 bg-clip-text text-transparent">
                Our Services
            </h2>
            <p class="text-xl text-gray-600 max-w-2xl mx-auto">
                Comprehensive automotive services for all makes and models in Coventry
            </p>
            <div class="w-24 h-1 bg-gradient-to-r from-blue-600 to-purple-600 mx-auto mt-4 rounded-full"></div>
        </div>
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
            <?php
            $top_services = array_slice($services_data['services'], 0, 6);
            foreach ($top_services as $service):
            ?>
                <?php $service = $service; include __DIR__ . '/../partials/service-card.php'; ?>
            <?php endforeach; ?>
        </div>
        <div class="text-center mt-12">
            <a href="/services" class="btn-modern inline-block bg-gradient-to-r from-blue-600 to-purple-600 text-white px-10 py-4 rounded-xl font-bold hover:from-blue-700 hover:to-purple-700 shadow-lg hover:shadow-xl transition-all duration-300 transform hover:scale-105">
                View All Services →
            </a>
        </div>
    </div>
</section>

<!-- Modern Trust Blocks with Icons -->
<section class="py-20 bg-gradient-to-br from-blue-50 via-white to-purple-50">
    <div class="container mx-auto px-4">
        <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
            <div class="text-center p-8 bg-white rounded-2xl shadow-lg hover:shadow-2xl transition-all duration-300 transform hover:scale-105 border border-gray-100">
                <div class="w-20 h-20 bg-gradient-to-br from-blue-500 to-blue-600 rounded-full flex items-center justify-center mx-auto mb-4 shadow-lg">
                    <svg class="w-10 h-10 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                    </svg>
                </div>
                <div class="text-5xl font-extrabold bg-gradient-to-r from-blue-600 to-purple-600 bg-clip-text text-transparent mb-2">
                    <?php echo date('Y') - (isset($business['established']) ? $business['established'] : 2010); ?>+
                </div>
                <p class="text-gray-600 font-semibold">Years Experience</p>
            </div>
            <div class="text-center p-8 bg-white rounded-2xl shadow-lg hover:shadow-2xl transition-all duration-300 transform hover:scale-105 border border-gray-100">
                <div class="w-20 h-20 bg-gradient-to-br from-purple-500 to-purple-600 rounded-full flex items-center justify-center mx-auto mb-4 shadow-lg">
                    <svg class="w-10 h-10 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                    </svg>
                </div>
                <div class="text-4xl font-extrabold bg-gradient-to-r from-blue-600 to-purple-600 bg-clip-text text-transparent mb-2">DVSA</div>
                <p class="text-gray-600 font-semibold">Approved Test Centre</p>
            </div>
            <div class="text-center p-8 bg-white rounded-2xl shadow-lg hover:shadow-2xl transition-all duration-300 transform hover:scale-105 border border-gray-100">
                <div class="w-20 h-20 bg-gradient-to-br from-green-500 to-green-600 rounded-full flex items-center justify-center mx-auto mb-4 shadow-lg">
                    <svg class="w-10 h-10 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
                    </svg>
                </div>
                <div class="text-5xl font-extrabold bg-gradient-to-r from-blue-600 to-purple-600 bg-clip-text text-transparent mb-2">100%</div>
                <p class="text-gray-600 font-semibold">Customer Satisfaction</p>
            </div>
        </div>
    </div>
</section>

<!-- Modern Reviews Preview -->
<section class="py-20 bg-gradient-to-b from-white via-gray-50 to-white">
    <div class="container mx-auto px-4">
        <div class="text-center mb-16 animate-fade-in-up">
            <h2 class="text-4xl md:text-5xl font-extrabold mb-4 bg-gradient-to-r from-blue-600 to-purple-600 bg-clip-text text-transparent">
                What Our Customers Say
            </h2>
            <p class="text-xl text-gray-600 max-w-2xl mx-auto">
                Trusted by drivers across Coventry
            </p>
            <div class="w-24 h-1 bg-gradient-to-r from-blue-600 to-purple-600 mx-auto mt-4 rounded-full"></div>
        </div>
        <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
            <?php
            $featured_reviews = array_slice($testimonials_data['testimonials'], 0, 3);
            foreach ($featured_reviews as $review):
            ?>
                <?php $review = $review; include __DIR__ . '/../partials/review-card.php'; ?>
            <?php endforeach; ?>
        </div>
        <div class="text-center mt-12">
            <a href="/reviews" class="btn-modern inline-block bg-gradient-to-r from-blue-600 to-purple-600 text-white px-10 py-4 rounded-xl font-bold hover:from-blue-700 hover:to-purple-700 shadow-lg hover:shadow-xl transition-all duration-300 transform hover:scale-105">
                Read All Reviews →
            </a>
        </div>
    </div>
</section>

<!-- CTA Section -->
<?php include __DIR__ . '/../partials/cta-strip.php'; ?>

<script>
// Quick Quote Calculator
document.getElementById('quick-quote-form').addEventListener('submit', async function(e) {
    e.preventDefault();
    
    const formData = new FormData(this);
    const data = Object.fromEntries(formData);
    
    try {
        const response = await fetch('/api/quote.php', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
            },
            body: JSON.stringify(data)
        });
        
        const result = await response.json();
        
        if (result.success) {
            document.getElementById('quote-price').textContent = result.price;
            document.getElementById('quote-time-text').textContent = result.time;
            document.getElementById('quote-results').classList.remove('hidden');
            document.getElementById('quote-results').scrollIntoView({ behavior: 'smooth', block: 'nearest' });
        } else {
            alert('Unable to calculate estimate. Please call us for a quote.');
        }
    } catch (error) {
        console.error('Error:', error);
        alert('Unable to calculate estimate. Please call us for a quote.');
    }
});
</script>

<?php include __DIR__ . '/../partials/footer.php'; ?>
