<?php
require_once __DIR__ . '/../config.php';
$current_slug = 'privacy-policy';
?>
<?php include __DIR__ . '/../partials/header.php'; ?>
<?php include __DIR__ . '/../partials/breadcrumbs.php'; ?>

<section class="py-16 bg-white">
    <div class="container mx-auto px-4">
        <div class="max-w-4xl mx-auto prose prose-lg">
            <h1 class="text-4xl font-bold mb-4">Privacy Policy</h1>
            <p class="text-gray-600 mb-8">Last updated: <?php echo date('F j, Y'); ?></p>
            
            <div class="space-y-6 text-gray-700">
                <div>
                    <h2 class="text-2xl font-bold mb-4">Introduction</h2>
                    <p>
                        <?php echo e($business['legal_name']); ?> ("we", "our", or "us") is committed to protecting your privacy. 
                        This Privacy Policy explains how we collect, use, and safeguard your personal information when you visit 
                        our website or use our services.
                    </p>
                </div>
                
                <div>
                    <h2 class="text-2xl font-bold mb-4">Information We Collect</h2>
                    <p>We may collect the following types of information:</p>
                    <ul class="list-disc pl-6 space-y-2">
                        <li><strong>Contact Information:</strong> Name, email address, phone number, and postal address when you contact us or book a service.</li>
                        <li><strong>Vehicle Information:</strong> Details about your vehicle when you request a quote or book a service.</li>
                        <li><strong>Website Usage Data:</strong> Information about how you interact with our website, including IP address, browser type, and pages visited.</li>
                        <li><strong>Cookies:</strong> We use cookies to enhance your browsing experience. See our Cookie Policy for more details.</li>
                    </ul>
                </div>
                
                <div>
                    <h2 class="text-2xl font-bold mb-4">How We Use Your Information</h2>
                    <p>We use the information we collect to:</p>
                    <ul class="list-disc pl-6 space-y-2">
                        <li>Respond to your inquiries and provide customer service</li>
                        <li>Process bookings and service requests</li>
                        <li>Send you service-related communications</li>
                        <li>Improve our website and services</li>
                        <li>Comply with legal obligations</li>
                    </ul>
                </div>
                
                <div>
                    <h2 class="text-2xl font-bold mb-4">Data Sharing</h2>
                    <p>
                        We do not sell, trade, or rent your personal information to third parties. We may share your information only:
                    </p>
                    <ul class="list-disc pl-6 space-y-2">
                        <li>With service providers who assist us in operating our business (under strict confidentiality agreements)</li>
                        <li>When required by law or to protect our rights</li>
                        <li>In connection with a business transfer (if applicable)</li>
                    </ul>
                </div>
                
                <div>
                    <h2 class="text-2xl font-bold mb-4">Data Security</h2>
                    <p>
                        We implement appropriate technical and organizational measures to protect your personal information against 
                        unauthorized access, alteration, disclosure, or destruction.
                    </p>
                </div>
                
                <div>
                    <h2 class="text-2xl font-bold mb-4">Your Rights</h2>
                    <p>Under data protection laws, you have the right to:</p>
                    <ul class="list-disc pl-6 space-y-2">
                        <li>Access your personal information</li>
                        <li>Correct inaccurate information</li>
                        <li>Request deletion of your information</li>
                        <li>Object to processing of your information</li>
                        <li>Data portability</li>
                    </ul>
                </div>
                
                <div>
                    <h2 class="text-2xl font-bold mb-4">Contact Us</h2>
                    <p>
                        If you have questions about this Privacy Policy or wish to exercise your rights, please contact us:
                    </p>
                    <p class="mt-4">
                        <strong><?php echo e($business['legal_name']); ?></strong><br>
                        <?php echo e($business['contact']['address']['full']); ?><br>
                        Phone: <a href="tel:<?php echo e($business['contact']['phone_formatted']); ?>" class="text-blue-600 hover:text-blue-700"><?php echo e($business['contact']['phone']); ?></a><br>
                        Please use our <a href="/contact" class="text-blue-600 hover:text-blue-700">contact form</a> to get in touch with us.
                    </p>
                </div>
            </div>
        </div>
    </div>
</section>

<?php include __DIR__ . '/../partials/footer.php'; ?>
