<?php
require_once __DIR__ . '/../config.php';
$current_slug = 'reviews';

// Calculate average rating
$total_rating = 0;
$review_count = count($testimonials_data['testimonials']);
foreach ($testimonials_data['testimonials'] as $review) {
    $total_rating += $review['rating'];
}
$average_rating = $review_count > 0 ? round($total_rating / $review_count, 1) : 0;
?>
<?php include __DIR__ . '/../partials/header.php'; ?>
<?php include __DIR__ . '/../partials/breadcrumbs.php'; ?>

<!-- Modern Reviews Page with Gradient -->
<section class="py-20 bg-gradient-to-br from-indigo-50 via-purple-50 to-pink-50 min-h-screen">
    <div class="container mx-auto px-4">
        <div class="max-w-7xl mx-auto">
            <!-- Header Section -->
            <div class="text-center mb-16 animate-fade-in-up">
                <h1 class="text-5xl md:text-6xl font-extrabold mb-4 bg-gradient-to-r from-indigo-600 via-purple-600 to-pink-600 bg-clip-text text-transparent">
                    Customer Reviews
                </h1>
                <p class="text-xl text-gray-600 max-w-2xl mx-auto">
                    See what our customers say about their experience
                </p>
                <div class="w-24 h-1 bg-gradient-to-r from-indigo-600 via-purple-600 to-pink-600 mx-auto mt-4 rounded-full"></div>
            </div>
            
            <!-- Average Rating Card -->
            <div class="text-center mb-16">
                <div class="inline-block bg-white rounded-3xl shadow-2xl p-8 border border-gray-100 transform hover:scale-105 transition-all duration-300">
                    <div class="flex items-center justify-center mb-4 gap-4">
                        <div class="text-6xl font-extrabold bg-gradient-to-r from-indigo-600 via-purple-600 to-pink-600 bg-clip-text text-transparent">
                            <?php echo $average_rating; ?>
                        </div>
                        <div class="flex text-yellow-400">
                            <?php for ($i = 0; $i < 5; $i++): ?>
                                <svg class="w-10 h-10 <?php echo $i < round($average_rating) ? 'text-yellow-400' : 'text-gray-300'; ?>" fill="currentColor" viewBox="0 0 20 20">
                                    <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"></path>
                                </svg>
                            <?php endfor; ?>
                        </div>
                    </div>
                    <p class="text-gray-600 font-semibold text-lg">Based on <?php echo $review_count; ?> <?php echo $review_count === 1 ? 'review' : 'reviews'; ?></p>
                </div>
            </div>
            
            <!-- Reviews Grid -->
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8 mb-16">
                <?php foreach ($testimonials_data['testimonials'] as $review): ?>
                    <?php include __DIR__ . '/../partials/review-card.php'; ?>
                <?php endforeach; ?>
            </div>
            
            <!-- Aggregate Rating Schema -->
            <script type="application/ld+json">
            {
                "@context": "https://schema.org",
                "@type": "LocalBusiness",
                "name": "<?php echo e($business['name'] ?? SITE_NAME); ?>",
                "aggregateRating": {
                    "@type": "AggregateRating",
                    "ratingValue": "<?php echo $average_rating; ?>",
                    "reviewCount": "<?php echo $review_count; ?>"
                }
            }
            </script>
            
            <!-- Leave Review Button -->
            <div class="text-center">
                <button onclick="openReviewModal()" 
                        class="btn-modern inline-flex items-center gap-3 bg-gradient-to-r from-indigo-600 via-purple-600 to-pink-600 text-white px-10 py-5 rounded-xl font-bold hover:from-indigo-700 hover:via-purple-700 hover:to-pink-700 shadow-lg hover:shadow-xl transition-all duration-300 transform hover:scale-105 text-lg">
                    <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11.049 2.927c.3-.921 1.603-.921 1.902 0l1.519 4.674a1 1 0 00.95.69h4.915c.969 0 1.371 1.24.588 1.81l-3.976 2.888a1 1 0 00-.363 1.118l1.518 4.674c.3.922-.755 1.688-1.538 1.118l-3.976-2.888a1 1 0 00-1.176 0l-3.976 2.888c-.783.57-1.838-.197-1.538-1.118l1.518-4.674a1 1 0 00-.363-1.118l-3.976-2.888c-.784-.57-.38-1.81.588-1.81h4.914a1 1 0 00.951-.69l1.519-4.674z"></path>
                    </svg>
                    Leave a Review
                </button>
            </div>
        </div>
    </div>
</section>

<!-- Review Modal -->
<?php include __DIR__ . '/../partials/review-modal.php'; ?>

<!-- CTA Section -->
<?php include __DIR__ . '/../partials/cta-strip.php'; ?>

<?php include __DIR__ . '/../partials/footer.php'; ?>
